% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piechart.R
\name{colorkey}
\alias{colorkey}
\title{Function to create a color key}
\usage{
colorkey(
  x0,
  y0,
  x1,
  y1,
  cols = c("white", "steelblue"),
  tick.range = c(0, 1),
  tick.marks = seq(tick.range[1], tick.range[2], length.out = 5L),
  label.from = NULL,
  label.to = NULL,
  nlevels = 100,
  main = NULL,
  relative = TRUE,
  tick.args = list(),
  label.args = list(),
  main.args = list()
)
}
\arguments{
\item{x0, x1, y0, y1}{Numeric scalars. Coordinates of the lower left and
upper right points where the color key will be drawn as proportion of
the plotting region.}

\item{cols}{Character scalar. Colors specifications to create the
color palette.}

\item{tick.range, tick.marks}{Numeric vectors specifying the range and
the tickmarks respectively.}

\item{label.from, label.to}{Character scalar. Labels of the lower and
upper values of the color key.}

\item{nlevels}{Integer scalar. Number of levels to extrapolate.}

\item{main}{Character scalar. Title of the colorkey.}

\item{relative}{Logical scalar. When \code{TRUE} the color key is drawn relative
to the plotting region area taking \verb{x0, x1, y0, y1} as relative location.}

\item{tick.args, label.args, main.args}{Lists of arguments passed to
\link[graphics:text]{graphics::text} for drawing ticks, labels and main respectively.}
}
\value{
NULL.
}
\description{
Function to create a color key
}
\examples{
set.seed(22231)

# A random figure
dat <- matrix(runif(100*3), ncol = 3)
col <- colorRamp2(c("blue", "white", "red"))

plot(
  dat[,1], dat[,2],
  col = rgb(col(dat[,3]), maxColorValue=255),
  cex=2, pch=20
  )

# Pretty color key
colorkey(
  x0 = .60, y0 = .80,
  x1 = .95, y1 = .95,
  cols = c("blue", "white", "red"),
  main = "Some color scale"
)
}
