% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netrankr.R
\docType{package}
\name{netrankr-package}
\alias{netrankr-package}
\alias{_PACKAGE}
\title{netrankr: An R package for centrality and partial rankings in networks}
\description{
netrankr provides several functions to analyze partial rankings for network
centrality. The main focus lies on methods that do not necessarily rely on indices like degree,
betweenness or closeness. However, the package also provides more than 20 indices,
which can be constructed via a Rstudio addin.

The package follows the philosophy, that centrality
can be decomposed in a series of micro steps. Starting from a network,
\link{indirect_relations} can be derived which can either be aggregated into an index with
\link{aggregate_positions}, or alternatively turned into a partial ranking with \link{positional_dominance}.
The partial ranking can then be further analyzed with \link{exact_rank_prob}, to obtain
probabilistic centrality rankings.
}
\details{
Some features of the package are:

\itemize{
\item Working with the neighborhood inclusion preorder. This forms the bases
for any centrality analysis on undirected and unweighted graphs.
More details can be found in the dedicated vignette:
\code{vignette("neighborhood_inclusion",package = "netrankr")}
\item Constructing graphs with a unique centrality ranking.
This class of graphs, known as threshold graphs, can be used to benchmark
centrality indices, since they only allow for one ranking of the nodes.
For more details consult the vignette: \code{vignette("threshold_graph",package = "netrankr")}
\item Probabilistic centrality. Why apply a handful of indices and choosing
the one that fits best, when it is possible to analyze \strong{all} centrality rankings at once?
The package includes several function to calculate rank probabilities of nodes
in a network. These include expected ranks and relative rank probabilities
(how likely is it that a node is more central than another?)
Consult \code{vignette("probabilistic_cent",package = "netrankr")} for more info.
}

The package provides several additional vignettes that explain the functionality
of netrankr and its conceptual ideas. See \code{browseVignettes(package = 'netrankr')}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/schochastics/netrankr/}
  \item Report bugs at \url{https://github.com/schochastics/netrankr/issues}
}

}
\author{
\strong{Maintainer}: David Schoch \email{david@schochastics.net} (\href{https://orcid.org/0000-0003-2952-4812}{ORCID})

Other contributors:
\itemize{
  \item Julian Müller \email{julian.mueller@gess.ethz.ch} [contributor]
}

}
\keyword{internal}
