% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotArgs.network}
\alias{plotArgs.network}
\title{Expand and transform attributes of networks to values appropriate for
aguments to plot.network}
\usage{
plotArgs.network(x, argName, argValue, d = NULL, edgetouse = NULL)
}
\arguments{
\item{x}{a \code{network} object which is going to be plotted}

\item{argName}{character, the name of \code{plot.network} graphic parameter}

\item{argValue}{value for the graphic paramter named in \code{argName} which
to be transformed/prepared.  For many attributes, if this is a single
character vector it will be assumed to be the name of a vertex or edge
attribute to be extracted and transformed}

\item{d}{is an edgelist matrix of edge values optionally used by some edge
attribute functions}

\item{edgetouse}{numeric vector giving set of edge ids to be used (in case
some edges are not being shown) required by some attributes}
}
\value{
returns a vector with length corresponding to the number of vertices
or edges (depending on the paramter type) giving the appropriately prepared
values for the parameter type.  If the values or specified attribute can not
be processed correctly, and Error may occur.
}
\description{
This is primairly an internal function called by \code{plot.network} or by
external packages such as \code{ndtv} that want to prepare
\code{plot.network} graphic arguments in a standardized way.
}
\details{
Given a network object, the name of graphic parameter argument to
\code{plot.network} and value, it will if necessary transform the value, or
extract it from the network, according to the description in
\code{\link{plot.network}}. For some attributes, if the value is the name of
a vertex or edge attribute, the appropriate values will be extracted from
the network before transformation.
}
\examples{

  net<-network.initialize(3)
  set.vertex.attribute(net,'color',c('red','green','blue'))
  set.vertex.attribute(net,'charm',1:3)
  # replicate a single colorname value
  plotArgs.network(net,'vertex.col','purple')
  # map the 'color' attribute to color
  plotArgs.network(net,'vertex.col','color')
  # similarly for a numeric attribute ...
  plotArgs.network(net,'vertex.cex',12)
  plotArgs.network(net,'vertex.cex','charm')

}
\seealso{
See also \code{\link{plot.network}}
}
\author{
skyebend@uw.edu
}
