sim.fmri.data <-
function(design=list(), image=list(), dim, nscan=NULL, TR=NULL, SNR, noise=c("none", "white", "temporal", "spatial", "low-frequency", "physiological", "task-related", "mixture"), temp=c("AR(1)", "state-space"), spat=c("corr", "gausRF", "gammaRF"), weights, verbose=TRUE, rhotemp=NULL, rhospat=NULL, lowfreq=NULL, heartfreq=NULL, respfreq=NULL, FWHM=NULL, gamma.shape=NULL, gamma.rate=NULL, anatomical=FALSE, template){

	# design: list generated by simprep.act.temp specifying the design. If not specified, noise images are generated.
	# image: list generated by simprep.act.spat specifying the activated regions. If not specified, noise images are generated
	# dim: dimensions of the image space
	# nscan: number of scans for noise images
	# TR: repetition time for noise images
	# SNR: signal-to-noise ratio
	# noise: type of noise, default is white
	# temp: if noise=temporal or mixture, the temporal correlation structure
	# spat: if noise=spatial or mixture, the spatial correlation structure
	# weights: if noise=mixture, weights vector of six elements
	# verbose: logical indicating if warning should be printed
        # rhotemp: if noise=temporal or noise=mixture, value of autocorrelation coefficient
	# rhospat: if noise=spatial or noise=mixture, and spat=corr, value of the correlation coefficient
        # lowfreq: if noise=low-frequency or noise=mixture, frequency of the low-frequency drift in seconds
        # heartfreq: if noise=physiological or noise=mixture, frequency of heart rate in Hz
        # respfreq: if noise=physiological or noise=mixture, frequency of respiratory rate in Hz
	# FWHM: if noise=spatial or noise=mixture, and spat=gausRF or gammaRF, value of the FWHM of the Gaussian kernel
	# gamma.shape: if noise=spatial or noise=mixture, and spat=gammaRF, value of the shape parameter of the gamma distribution
	# gamma.rate: if noise=spatial or noise=mixture, and spat=gammaRF, value of the rate parameter of the gamma distribution

  if((length(design)!=0) && (length(image)==0)){
    stop("image list is missing")
  }
  if((length(design)==0) && (length(image)!=0)){
    stop("design list is missing")
  }
  if((length(design)==0) && (length(image)==0)){
    if(is.null(nscan)){
      stop("nscan of noise data is missing")
    }
    if(is.null(TR)){
      stop("TR of noise data is missing")
    }
  }
  if(length(design)>1){
    if(length(design)!=length(image)){
      stop("Mismatch between design and image list.")
    }
  }
  if(missing(dim)){
    stop("dim of the image space is missing")
  } else {
    if((length(dim)<2) || (length(dim)>3)){
      stop("dim should represent a 2D or 3D image space")
    }
  }
  if(missing(SNR)){
    stop("SNR is missing")
  }
  if(missing(noise)){
    noise <- "white"
  }
  if((noise=="temporal") || (noise=="mixture")){
    if(missing(temp)){
      temp <- "AR(1)"
    }
  }
  if((noise=="spatial") || (noise=="mixture")){
    if(missing(spat)){
      spat <- "corr"
    }
  }
  if(noise=="mixture"){
    if(missing(weights)){
      stop("Weights should be provided with noise=mixture.")
    }
    if(length(weights)!=6){
      stop("Weights vector should have 6 elements.")
    }
    if(sum(weights)!=1){
      stop("The sum of the weights vector should be equal to 1.")
    }
  }
  if((anatomical==TRUE) && missing(template)){
    stop("Template image is required when anatomical==TRUE")
  }

  if((length(design)==0) && (length(image)==0)){
    act.image <- array(0, dim=c(dim,nscan))
    sigma <- SNR
  } else if(length(design)==1){
    nregio <- length(image)
    nscan <- design[[1]]$T/design[[1]]$TR
    TR <- design[[1]]$TR
    act.image <- array(0, dim=c(dim,nscan))
    act <- rowSums(specify.design(design[[1]]$ncond, design[[1]]$onsets, design[[1]]$durations, design[[1]]$T, design[[1]]$TR, design[[1]]$acc, design[[1]]$hrf, par=design[[1]]$par))
    sigma <- sd(act)/SNR
    for(i in 1:nregio){
      im <- specify.region(dim, image[[i]]$coord, image[[i]]$ext, image[[i]]$form, image[[i]]$fading)
      act.image <- act.image + im %o% act
    }
  } else {
    nregio <- length(image)
    nscan <- design[[1]]$T/design[[1]]$TR
    TR <- design[[1]]$TR
    act.image <- array(0, dim=c(dim,nscan))
    sd.act <- rep(NA, nregio)
    for(i in 1:nregio){
      im <- specify.region(dim, image[[i]]$coord, image[[i]]$ext, image[[i]]$form, image[[i]]$fading)
      act <- rowSums(specify.design(design[[i]]$ncond, design[[i]]$onsets, design[[i]]$durations, design[[i]]$T, design[[i]]$TR, design[[i]]$acc, design[[i]]$hrf, par=design[[i]]$par))
      sd.act[i] <- sd(act)
      act.image <- act.image + im %o% act
    }
    sigma <- mean(sd.act)/SNR
  }

  if(noise=="none"){
    n <- 0
  }
  if(noise=="white"){
    n <- gaussnoise.fnc(dim, sigma, nscan, verbose=verbose, anatomical=anatomical, template=template)
  }
  if(noise=="temporal"){
    if(temp=="AR(1)"){
      n <- AR1noise.fnc(dim, sigma, nscan, rhotemp, verbose=verbose, anatomical=anatomical, template=template)
    }
    if(temp=="state-space"){
      stop("State-space temporal noise model is not yet implemented.")
    }
  }
  if(noise=="low-frequency"){
    n <- lowfreq.fnc(dim, lowfreq, nscan=nscan, TR=TR, verbose=verbose, anatomical=anatomical, template=template)
  }
  if(noise=="physiological"){
    n <- physnoise.fnc(dim, sigma, nscan, TR, heartfreq, respfreq, verbose=verbose, anatomical=anatomical, template=template)
  }
  if(noise=="task-related"){
    n <- tasknoise.fnc(dim, act, sigma)
  }
  if(noise=="spatial"){
    n <- spatnoise.fnc(dim, sigma, nscan, spat, rhospat, FWHM, gamma.shape, gamma.rate, anatomical=anatomical, template=template, verbose=verbose)
  }
  if(noise=="mixture"){
    if(weights[1]==0){
      n.white <- 0
    } else {
      n.white <- gaussnoise.fnc(dim, sigma, nscan, verbose=verbose, anatomical=anatomical, template=template)
    }
    if(weights[2]==0){
      n.temp <- 0
    } else {
      if(temp=="AR(1)"){
       	n.temp <- AR1noise.fnc(dim, sigma, nscan, rhotemp, verbose=verbose, anatomical=anatomical, template=template)
      }
      if(temp=="state-space"){
       	stop("State-space temporal noise model is not yet implemented.")
      }
    }
    if(weights[3]==0){
      n.low <- 0
    } else {
      n.low <- lowfreq.fnc(dim, lowfreq, nscan=nscan, TR=TR, verbose=verbose, anatomical=anatomical, template=template)
    }
    if(weights[4]==0){
      n.phys <- 0
    } else {
      n.phys <- physnoise.fnc(dim, sigma, nscan, TR, heartfreq, respfreq, verbose=verbose, anatomical=anatomical, template=template)
    }
    if(weights[5]==0){
      n.task <- 0
    } else {
      n.task <- tasknoise.fnc(c(dim,nscan), act.image, sigma)
    }
    if(weights[6]==0){
      n.spat <- 0
    } else {
      n.spat <- spatnoise.fnc(dim, sigma, nscan, spat, rhospat, FWHM, gamma.shape, gamma.rate, anatomical=anatomical, template=template, verbose=verbose)
    }
    w <- weights
    n <- w[1]* n.white + w[2]*n.temp + w[3]*n.low + w[4]*n.phys + w[5]*n.task + w[6]*n.spat
  }
  
  fmri.data <- act.image + n
        if(anatomical==TRUE){
                if(missing(template)){
                        stop("Template image is required when anatomical==TRUE")
                }
                template.time <- array(rep(template,nscan), dim=c(dim,nscan))
                ix <- which(template.time!=0)
                fmri.data[-ix] <- 0
        }

  return(fmri.data)
}

