% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.NeuralGAM.R
\name{print.neuralGAM}
\alias{print.neuralGAM}
\title{Short \code{neuralGAM} summary}
\usage{
\method{print}{neuralGAM}(x, ...)
}
\arguments{
\item{x}{A \code{neuralGAM} object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Prints a brief summary of the fitted model including:
\describe{
\item{Distribution family}{The distribution family used (\code{"gaussian"}, \code{"binomial"}, or \code{"poisson"}).}
\item{Formula}{The model formula.}
\item{Intercept value}{The fitted intercept (\eqn{\eta_0}).}
\item{Mean Squared Error (MSE)}{The training MSE of the model.}
\item{Training sample size}{The number of observations used to train the model.}
}
}
\description{
Default print method for a \code{neuralGAM} object.
}
\examples{
\dontrun{


library(neuralGAM)
dat <- sim_neuralGAM_data()
train <- dat$train
test  <- dat$test

ngam <- neuralGAM(
  y ~ s(x1) + x2 + s(x3),
  data = train,
  num_units = 128,
  family = "gaussian",
  activation = "relu",
  learning_rate = 0.001,
  bf_threshold = 0.001,
  max_iter_backfitting = 10,
  max_iter_ls = 10,
  seed = 1234
)
print(ngam)
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
