% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVector.R, R/BrainVolume.R
\docType{methods}
\name{as.sparse}
\alias{as.sparse}
\alias{as.sparse,DenseBrainVector,LogicalBrainVolume-method}
\alias{as.sparse,DenseBrainVector,numeric-method}
\alias{as.sparse,DenseBrainVolume,LogicalBrainVolume-method}
\alias{as.sparse,DenseBrainVolume,numeric-method}
\title{Convert to from dense to sparse representation}
\usage{
as.sparse(x, mask, ...)

\S4method{as.sparse}{DenseBrainVector,LogicalBrainVolume}(x, mask)

\S4method{as.sparse}{DenseBrainVector,numeric}(x, mask)

\S4method{as.sparse}{DenseBrainVolume,LogicalBrainVolume}(x, mask)

\S4method{as.sparse}{DenseBrainVolume,numeric}(x, mask)
}
\arguments{
\item{x}{the object to make sparse, e.g. \code{DenseBrainVolume} or \code{DenseBrainVector}}

\item{mask}{the elements to retain}

\item{...}{additional arguments}
}
\description{
Convert to from dense to sparse representation
}
\details{
\code{mask} can be an integer vector of 1D indices or a mask volume of class \code{LogicalBrainVolume}
}
\examples{
bvol <- BrainVolume(array(runif(24*24*24), c(24,24,24)), BrainSpace(c(24,24,24), c(1,1,1)))
indmask <- sort(sample(1:(24*24*24), 100))
svol <- as.sparse(bvol, indmask)


mask <- LogicalBrainVolume(runif(length(indmask)), space=space(bvol), indices=indmask)
sum(mask) == 100
}

