% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.R
\name{ROIVol}
\alias{ROIVol}
\title{Create ROI Volume Object}
\usage{
ROIVol(space, coords, data)
}
\arguments{
\item{space}{A \code{\linkS4class{NeuroSpace}} object defining the spatial reference}

\item{coords}{A matrix with 3 columns representing (x,y,z) coordinates}

\item{data}{A numeric vector of values corresponding to each coordinate}
}
\value{
An \code{\linkS4class{ROIVol}} object
}
\description{
Creates an \code{\linkS4class{ROIVol}} object representing a set of values
at specific 3D coordinates within a spatial reference system.
}
\details{
ROI Volume
}
\examples{
space <- NeuroSpace(c(64,64,64))
coords <- matrix(c(1,2,3, 4,5,6), ncol=3, byrow=TRUE)
data <- c(1.5, 2.5)
roi_vol <- ROIVol(space, coords, data)

}
