% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidebar.R
\name{sidebarPanel}
\alias{sidebarPanel}
\title{Create the sidebar panel}
\usage{
sidebarPanel(..., title = "TitleApp", footer = FALSE)
}
\arguments{
\item{...}{The elements to include within the body of the sidebar}

\item{title}{Title of the sidebar content}

\item{footer}{Whether or not to enable the footer content}
}
\value{
An HTML containing elements of a sidebar to be embedded in a page
}
\description{
Creates an advanced sidebar panel with colors corresponding to a chosen theme style
}
\note{
This global layout can be applied to a variety of shiny app and dashboard, with or without a sidebar. See the example below.
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)

  shiny::shinyApp(
    ui = fluidPage(
      style = "7",
      header = NULL,
      sidebar = sidebarPanel(
        title = "myApp",
        "Sample sidebar contents",
        footer = FALSE
      ),
      "Plain content"
    ),
    server = function(input, output) {}
  )
}
}
}
