% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordions.R
\name{accordion}
\alias{accordion}
\title{Generate an accordion}
\usage{
accordion(..., id, style = c("default", "1", "2", "3", "4"), uncollapsed = 1)
}
\arguments{
\item{...}{The accordionItem elements to include within the body of the particular accordion}

\item{id}{The identification of the accordion}

\item{style}{Style of the accordion, use "default", "1", "2", "3", "4"}

\item{uncollapsed}{Indicate by number which accordionItem should not be collapsed}
}
\value{
HTML of a container with a class called accordion
}
\description{
Wrap one or more accordion items into a container
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)

  shiny::shinyApp(
    ui = fluidPage(
      style = "8",
      custom.bg.color = "white",
      sidebar = NULL,
      header = NULL,
      accordion(
        id = "accordion5",
        style = "2",
        accordionItem(
          title = "Accordion 1",
          icon = shiny::icon("edit"),
          "Massa sed elementum sus"
        ),
        accordionItem(
          title = "Accordion 2",
          icon = shiny::icon("cog"),
          "Auctor neque etiam non."
        )
      )
    ),
    server = function(input, output) {
    }
  )
}
}

}
