% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluidPage.R
\name{fluidPage}
\alias{fluidPage}
\title{Generate a container for the application}
\usage{
fluidPage(
  ...,
  id = NULL,
  header = NULL,
  sidebar = NULL,
  class = NULL,
  style = rand.sc13,
  custom.bg.color = NULL,
  modal.header.links = NULL
)
}
\arguments{
\item{...}{The elements to include within the body of the page}

\item{id}{OPTIONAL. Identification tag of the container}

\item{header}{OPTIONAL. Items to display in the header section (use the titlePanel() function to set this property).}

\item{sidebar}{OPTIONAL. Items to display in the sidebay section (use the sidebarPanel() function to set this property).}

\item{class}{OPTIONAL. Class name for the container}

\item{style}{OPTIONAL. Various unique styles choices from 1 - 12}

\item{custom.bg.color}{OPTIONAL. Choice to change the background color of the container. Use HEX values such as #FFFFFF or RGB code such as rgb(255,255,255) or simple color name such as 'lightblue'}

\item{modal.header.links}{OPTIONAL. One or more list containing links that appear when the app title is clicked. To remove, set to NULL}
}
\value{
A rendered HTML of the container holder of the application items
}
\description{
An upgrade to the fluidPage function available in the 'Shiny' package
}
\note{
This global layout can be applied to a variety of shiny app and dashboard, with or without a sidebar. See the example below.
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)

  shiny::shinyApp(
    ui = fluidPage(
      style = "6",
      header = titlePanel(left = "Sample App Title",
      right = "Image/logo"),
      sidebar = sidebarPanel(
        title = "myApp",
        "Sample sidebar content"
      ),
      "Sample body content"
    ),
    server = function(input, output) {}
  )
}
}
}
