% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form.R
\name{textInput}
\alias{textInput}
\title{Create an advanced text input}
\usage{
textInput(
  inputId,
  label,
  value = "",
  width = NULL,
  placeholder = NULL,
  size = c("m", "s", "l", "xl"),
  style = c("default", "pill", "round", "clean"),
  border.type = c("none", "primary", "secondary", "info", "success", "danger", "warning"),
  prepend = NULL,
  append = NULL,
  disabled = FALSE
)
}
\arguments{
\item{inputId}{The identification name}

\item{label}{The label for the input}

\item{value}{The current value of the input}

\item{width}{width of the text input}

\item{placeholder}{A placeholder text}

\item{size}{The size of the input, "m", "s", "l", "xl"}

\item{style}{Style to adapt, options include "default", "pill", "round", "clean"}

\item{border.type}{Add a border coloring using either of "none", "primary","secondary", "info", "success", "danger", "warning"}

\item{prepend}{Add  a prepended text or icon}

\item{append}{Add an appended text or icon}

\item{disabled}{Boolean. If textInput should be disabled}
}
\value{
A HTML with modifications to th style information
}
\description{
Modifications to textInput to allow added functionality and styles
}
\note{
For more information on the features of the form, visit the examples section of the help documentation
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)

  shiny::shinyApp(
    ui = fluidPage(
      style = "8",
      custom.bg.color = "white",
      sidebar = NULL,
      header = NULL,
      card(
        header = FALSE,
        tags$h3("Text input"),
        textInput("caption", "Basic"),
        textInput("caption", "Basic", style = "clean"),
        textInput("caption", "Border - primary",
          "Enter sample text",
          prepend = "@", border.type = "info"
        ),
        textInput("caption", "Border - primary",
          "Enter sample text",
          prepend = shiny::icon("lock")
        ),
        textInput("caption", "Border - primary",
          "Enter sample text",
          append = "\%"
        ),
        textInput("caption", "Border - primary",
          "Enter sample text",
          prepend = shiny::icon("chart"),
          append = ".00"
        )
      )
    ),
    server = function(input, output) {
    }
  )
}
}

}
