% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset.R
\docType{methods}
\name{t}
\alias{t}
\alias{t,CompositionMatrix-method}
\alias{t,LogRatio-method}
\title{Matrix Transpose}
\usage{
\S4method{t}{CompositionMatrix}(x)

\S4method{t}{LogRatio}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}
}
\value{
A \code{matrix}, with dim and dimnames constructed appropriately from those of \code{x}.
}
\description{
Matrix Transpose
}
\note{
Implemented only to ensure that \code{t()} always returns a base \code{matrix}.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)
head(coda)

## Subset
coda[[1, 1]] # Get the first value
coda[1] # Get the first value
coda[, ] # Get all values
coda[1, ] # Get the first row

## Subcomposition
subcoda <- coda[, 1:3] # Get the first three column
head(subcoda)
}
\author{
N. Frerebeau
}
\keyword{internal}
