% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learn.R
\name{learn}
\alias{learn}
\title{Learn an nfer specification from an event trace.}
\usage{
learn(events, loglevel = 0)
}
\arguments{
\item{events}{The dataframe containing events.}

\item{loglevel}{(Optional) The logging level to set (0-4), where 0 is only
warnings and errors and 3 is debug.  Default is 0.}
}
\value{
A handle to a learned nfer specification, loaded into R.
}
\description{
This function applies the nfer mining algorithm to a trace to attempt to
learn a specification.  It will only learn before rules and will only find
those when there is periodic behavior in the trace.  This works best for
system traces of real-time systems where events represent scheduled,
periodic behavior.  At this time, only the event names will be considered
while any data is ignored.
}
\details{
Event traces are passed as dataframes with at least two columns.
The first two columns contain event names and timestamps, respectively.
Names should be strings.  Timestamps should be integers or strings, ideally,
but may be numeric.
Subsequent columns will be ignored by this function, for now.

Example dataframe events: \preformatted{
| name | timestamp | x |    y |
-------------------------------
| foo  | 123       | 2 | NA   |
| bar  | 987       | 3 | TRUE |
}
}
\examples{
events <- nfer::read(system.file("extdata", "qnx.events", package = "nfer"))
learned <- nfer::learn(events)
learned <- nfer::learn(events, loglevel=1)
}
