% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_nflfastR_pbp.R
\name{build_nflfastR_pbp}
\alias{build_nflfastR_pbp}
\title{Build a Complete nflfastR Data Set}
\usage{
build_nflfastR_pbp(
  game_ids,
  source = "nfl",
  pp = FALSE,
  ...,
  decode = FALSE,
  rules = TRUE
)
}
\arguments{
\item{game_ids}{Vector of character ids (see details for further information).}

\item{source}{Character - \code{nfl} for the NFL.com page or \code{old} for the old gamecenter. For \code{old}, old_game_id must be supplied}

\item{pp}{Logical - either \code{TRUE} or \code{FALSE} (see details for further information)}

\item{...}{Additional arguments passed to the scraping functions (for internal use)}

\item{decode}{If \code{TRUE}, the function \code{\link{decode_player_ids}} will be executed.}

\item{rules}{If \code{FALSE}, printing of the header and footer in the console output will be suppressed.}
}
\value{
An nflfastR play-by-play data frame like it can be loaded from \url{https://github.com/guga31bb/nflfastR-data}.
}
\description{
\code{build_nflfastR_pbp} is a convenient wrapper around 5 nflfastR functions:

\itemize{
 \item{\code{\link{fast_scraper}}}
 \item{\code{\link{clean_pbp}}}
 \item{\code{\link{add_qb_epa}}}
 \item{\code{\link{add_xyac}}}
 \item{\code{\link{decode_player_ids}}}
}

Please see the documentation of each function to learn about the output.
}
\details{
To load valid game_ids please use the package function \code{\link{fast_scraper_schedules}}.

The \code{source} parameter controls from which source the data is being
loaded. The old parameters \code{rs} as well as \code{gc}
are not valid anymore. Please use \code{nfl} or \code{old}.

The \code{pp} parameter controls if the scraper should use parallel processing.
Please note that the initiating process takes a few seconds which means it
may be better to set \code{pp = FALSE} if you are scraping just a few games.
}
\examples{
\donttest{
# Build nflfastR pbp for the 2018 and 2019 Super Bowls
build_nflfastR_pbp(c("2018_21_NE_LA", "2019_21_SF_KC"))
}
}
