% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ep_wp_calculators.R
\name{calculate_win_probability}
\alias{calculate_win_probability}
\title{Compute win probability}
\usage{
calculate_win_probability(pbp_data)
}
\arguments{
\item{pbp_data}{Play-by-play dataset to estimate win probability for.}
}
\value{
The original pbp_data with the following columns appended to it:
\describe{
\item{wp}{win probability.}
\item{vegas_wp}{win probability taking into account pre-game spread.}
}
}
\description{
for provided plays. Returns the data with
probabilities of winning the game. The following columns
must be present: receive_h2_ko (1 if game is in 1st half and possession
team will receive 2nd half kickoff, 0 otherwise), ep (expected points),
home_team, posteam, half_seconds_remaining, game_seconds_remaining,
spread_line (how many points home team was favored by), down, ydstogo,
posteam_timeouts_remaining, defteam_timeouts_remaining
}
\details{
Computes win probability for provided plays. Returns the data with
probabilities of each scoring event and EP added. The following columns
must be present:
\itemize{
\item{receive_2h_ko (1 if game is in 1st half and possession team will receive 2nd half kickoff, 0 otherwise)}
\item{ep (expected points)}
\item{score_differential}
\item{home_team}
\item{posteam}
\item{half_seconds_remaining}
\item{game_seconds_remaining}
\item{spread_line (how many points home team was favored by)}
\item{down}
\item{ydstogo}
\item{posteam_timeouts_remaining}
\item{defteam_timeouts_remaining}
}
}
