% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_pbp.R
\name{load_pbp}
\alias{load_pbp}
\title{Load complete nflfastR Play by Play Datasets}
\usage{
load_pbp(seasons, ..., qs = FALSE)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given NFL seasons.}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{\link[=update_db]{update_db()}}).}

\item{qs}{Wheter to use the function \code{\link[qs:qdeserialize]{qs::qdeserialize()}} for more efficient loading.}
}
\value{
The complete nflfastR dataset as returned by \code{\link[=build_nflfastR_pbp]{build_nflfastR_pbp()}} for
all given \code{seasons}
}
\description{
Loads multiple seasons from the nflfastR datarepo either into memory
or writes them into a database using some forwarded arguments in the dots.
}
\examples{
\donttest{
pbp <- load_pbp(2019:2020, qs = TRUE)
dplyr::glimpse(pbp)
}
}
\seealso{
For information on parallel processing and progress updates please
see \link{nflfastR}.
}
