% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenate.r
\name{concatenate}
\alias{concatenate}
\title{Concatenate}
\usage{
concatenate(..., collapse = " ", rm.space = FALSE)
}
\arguments{
\item{...}{Input text(s).}

\item{collapse}{A character to separate the input strings if a vector of
strings is supplied; otherwise this does nothing.}

\item{rm.space}{logical; determines if spaces should be removed from the
final string.}
}
\value{
A string.
}
\description{
A quick utility for concatenating strings together.  This is
handy because if you want to generate the n-grams for several different
texts, you must first put them into a single string unless the text is
composed of sentences that should not be joined.
}
\examples{
library(ngram)

words <- c("a", "b", "c")
wordcount(words)
str <- concatenate(words)
wordcount(str)

}
\seealso{
\code{\link{preprocess}}
}
\keyword{Preprocessing}

