% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{opt_parser}
\alias{opt_parser}
\title{A function to create an instance of a parser object with subcommands.}
\usage{
opt_parser(subcmds_list = list(), subcmds_sections = list(), ...)
}
\arguments{
\item{subcmds_list}{A list setting the subcommands name and short description 
(e.g. list(subcmd1='Method1 to plot boxplot'))}

\item{subcmds_sections}{A list setting the sections of subcommands 
(e.g. list(subcmd_group_1=c('subcmd1', 'subcmd2'), subcmd_group_2=c('subcmd2')))}

\item{...}{Parameters pass to \code{\link[optparse]{OptionParser}}}
}
\description{
Modifed from \code{\link[optparse]{OptionParser}}
}
\examples{

option_list <- list(
  make_option(c('-l', '--list-all-subcmds'), action = 'store_true', 
              default = FALSE, help = 'Print all supported subcmds of ngsjs.')
)
subcmds_list <- list(subcmd1 = 'Use method 1 to plot boxplot', 
                     subcmd2 = 'Use method 2 to plot boxplot')
description <- 'Method to plot boxplot'
usage <- 'usage: \%prog [options] [params]'
opt_parser_obj <- opt_parser(subcmds_list = subcmds_list, 
                            option_list = option_list,
                            description = description,
                            usage = usage)
}
