% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesAttr}
\alias{nhanesAttr}
\title{Returns the attributes of an NHANES data table.}
\usage{
nhanesAttr(nh_table)
}
\arguments{
\item{nh_table}{The name of the specific table to retrieve}
}
\value{
The following attributes are returned as a list \cr
nrow = number of rows \cr
ncol = number of columns \cr
names = name of each column \cr
unique = true if all SEQN values are unique \cr
na = number of 'NA' cells in the table \cr
size = total size of table in bytes \cr
types = data types of each column
}
\description{
Returns attributes such as number of rows, columns, and memory size,
but does not return the table itself.
}
\details{
nhanesAttr allows one to check the size and other
  charactersistics of a data table before importing into R. To
  retrieve these characteristics, the specified table is
  downloaded, characteristics are determined, then the table is
  deleted. Downloads a table from the NHANES website as is, i.e. in
  its entirety with no modification or cleansing. If the
  environment variable \code{NHANES_TABLE_BASE} was set during
  startup, the value of this variable is used as the base URL
  instead of \url{https://wwwn.cdc.gov} (this allows the use of a
  local or alternative mirror of the CDC data).
}
\examples{
\donttest{bpx_e = nhanesAttr('BPX_E')}
\donttest{length(bpx_e)}
\donttest{folate_f = nhanesAttr('FOLATE_F')}
\donttest{length(folate_f)}
}
