% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{terminal_reaches}
\alias{terminal_reaches}
\title{Return terminal reaches from collection intersecting lake}
\usage{
terminal_reaches(lon = NA, lat = NA, buffer_dist = 0.01,
  network = NA, lakepoly = NA, lakewise = FALSE,
  lakesize_threshold = 4, approve_all_dl = FALSE, ...)
}
\arguments{
\item{lon}{numeric decimal degree longitude. optional. See Details section.}

\item{lat}{numeric decimal degree latitude. optional. See Details section.}

\item{buffer_dist}{numeric buffer around lat-lon point in dec. deg.}

\item{network}{sf lines collection. optional. See Details section.}

\item{lakepoly}{sf polygon.  optional. See Details section.}

\item{lakewise}{logical. If TRUE, return the terminal reaches of all lakes
in the stream network rather than a single terminal reach of the focal lake.}

\item{lakesize_threshold}{numeric above which to count as a lake (ha)}

\item{approve_all_dl}{logical blanket approval to download all missing data}

\item{...}{parameters passed on to sf::st_read}
}
\description{
In the case of a network query, a terminal reach is a stream flowline that
has no downstream reaches in-network. In the case of a point query, a
terminal reach is a flowline that exits the intersecting surface waterbody.
}
\details{
There are multiple ways to execute \code{\link{terminal_reaches}}:
\itemize{
 \item Only providing lon + lat arguments - this will query the
 corresponding lake polygon layer and find the terminal reach of the lake
 intersecting a buffer around the specified point.
 \item Only providing a lake polygon - this is essentially the same as
 above except there is no preliminary lake polygon query.
 \item Only providing a network of stream lines - this provides the most
 downstream reach irrespective of lakes.
}
}
\examples{
\dontrun{
library(sf)
library(mapview)

coords <- data.frame(lat = 46.32711, lon = -89.58893)
t_reach <- terminal_reaches(coords$lon, coords$lat)

coords  <- data.frame(lat = 44.6265, lon = -86.23121)
t_reach <- terminal_reaches(coords$lon, coords$lat, lakewise = TRUE)

coords  <- data.frame(lat = 42.96628 , lon = -89.25264)
t_reach <- terminal_reaches(coords$lon, coords$lat)

coords  <- data.frame(lat = 20.79722, lon = -156.47833)
t_reach <- terminal_reaches(coords$lon, coords$lat)

coords  <- data.frame(lat = 41.42217, lon = -73.24189)
t_reach <- terminal_reaches(coords$lon, coords$lat)

mapview(st_as_sf(coords, coords = c("lon", "lat"), crs = 4326)) +
mapview(t_reach$geometry, color = "red")

coords <- data.frame(lat = 41.859080, lon = -71.575422)
network <- nhd_plus_query(lon = coords$lon, lat = coords$lat,
                     dsn = "NHDFlowline", buffer_dist = 0.05)$sp$NHDFlowline
t_reach      <- terminal_reaches(network = network)
t_reach_lake <- terminal_reaches(network = network, lakewise = TRUE,
                                 lakesize_threshold = 1)

mapview(poly) + mapview(network) + mapview(t_reach, color = "red") +
mapview(t_reach_lake, color = "green")
}
}
