% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{leaf_reaches}
\alias{leaf_reaches}
\title{Return leaf reaches from a network or query intersecting lake}
\usage{
leaf_reaches(lon = NA, lat = NA, network = NA, approve_all_dl = FALSE, ...)
}
\arguments{
\item{lon}{numeric decimal degree longitude. optional. See Details section.}

\item{lat}{numeric decimal degree latitude. optional. See Details section.}

\item{network}{sf lines collection. optional. See Details section.}

\item{approve_all_dl}{logical blanket approval to download all missing data. Defaults to TRUE if session is non-interactive.}

\item{...}{parameters passed on to sf::st_read}
}
\value{
An sf data frame with LINESTRING geometries
}
\description{
A leaf reach is a stream flowline that has upstream connections but is
not in the focal set.
}
\examples{
\dontrun{
coords <- data.frame(lat = 20.79722, lon = -156.47833)
leaf_reaches(coords$lon, coords$lat)

coords  <- data.frame(lat = 41.42217, lon = -73.24189)
l_reach <- leaf_reaches(coords$lon, coords$lat)

network <- nhd_plus_query(lon = coords$lon, lat = coords$lat,
  dsn = "NHDFlowline", buffer_dist = 0.02)$sp$NHDFlowline
l_reach <- leaf_reaches(network = network)

plot(network$geometry)
plot(l_reach$geometry, col = "red", add = TRUE)
}
}
