% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nhdplus.R
\name{get_nhdplus}
\alias{get_nhdplus}
\title{Get National Hydrography Dataset V2 Subsets (Multirealization)}
\usage{
get_nhdplus(
  AOI = NULL,
  comid = NULL,
  nwis = NULL,
  realization = "flowline",
  streamorder = NULL,
  t_srs = NULL
)
}
\arguments{
\item{AOI}{sf (MULTI)POINT or (MULTI)POLYGON. An 'area of interest' can
be provided as either a location (sf POINT) or area (sf POLYGON)
in any Spatial Reference System.}

\item{comid}{numeric or character. Search for NHD features by COMID(s)}

\item{nwis}{numeric or character. Search for NHD features by
collocated NWIS identifiers}

\item{realization}{character. What realization to return.
Default is flowline and options include: outlet, flowline, catchment,
and all}

\item{streamorder}{numeric or character. Only return NHD flowlines with a
streamorder greater then or equal to this value
for input value and higher.
Only usable with AOI and flowline realizations.}

\item{t_srs}{character (PROJ string or EPSG code) or numeric (EPSG code).
A user specified - target -Spatial Reference System (SRS/CRS) for returned objects.
Will default to the CRS of the input AOI if provided, and to 4326 for ID requests.}
}
\value{
sfc a single, or list, of simple feature objects
}
\description{
Subsets NHDPlusV2 features by location (POINT), area (POLYGON),
or set of COMIDs. Multi realizations are supported allowing you to query
for flowlines, catchments, or outlets.
}
\details{
The returned object(s) will have the same
Spatial Reference System (SRS) as the input AOI. If a individual or set of
IDs are used to query, then the default geoserver CRS of EPSG:4326 is
preserved. In all cases, a user-defined SRS can be passed to \code{t_srs}
which will override all previous SRS's (either input or default).
All buffer and distance operations are handled internally using in
EPSG:5070 Albers Equal Area projection
}
\examples{
\donttest{
 point <- sf::st_sfc(sf::st_point(c(-119.845, 34.4146)), crs = 4326)
 get_nhdplus(point)
 get_nhdplus(point, realization = "catchment")
 get_nhdplus(point, realization = "all")
 get_nhdplus(comid = 101)
 get_nhdplus(nwis  = c(11120000, 11120500))
 area <- sf::st_as_sfc(sf::st_bbox(c(xmin = -119.8851, xmax =-119.8361,
 ymax = 34.42439, ymin = 34.40473), crs = 4326))
 get_nhdplus(area)
 get_nhdplus(area, realization = "flowline", streamorder = 3)
 }
}
