% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp_sequential.R
\name{ppp_sequential}
\alias{ppp_sequential}
\title{Simulate a homogeneous Poisson Point Process over (t_min, t_max]}
\usage{
ppp_sequential(
  range_t = c(0, 10),
  rate = 1,
  tol = 10^-6,
  rng_stream = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{range_t}{(vector, double) min and max of the time interval}

\item{rate}{(scalar, double) constant instantaneous rate}

\item{tol}{the probability that we will have more than
the drawn events in (t_min, t_max]}

\item{rng_stream}{an \code{rstream} object}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Simulate a homogeneous Poisson Point Process over (t_min, t_max]
}
\examples{
x <- ppp_sequential(range_t = c(0, 10), rate = 1, tol = 10^-6)
}
