% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp2.R
\name{ppp2}
\alias{ppp2}
\title{Simulate a homogeneous Poisson Point Process over (t_min, t_max] (order statistics method)}
\usage{
ppp2(rate, t_min, t_max, atmost1 = FALSE)
}
\arguments{
\item{rate}{(scalar, double) constant instantaneous rate}

\item{t_min}{(scalar, double) the lower bound of the time interval}

\item{t_max}{(scalar, double) the upper bound of the time interval}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Internal function -- not to be exported.
Same as \code{ppp} but uses the Order Statistics algorithm.
}
\examples{
x <- ppp(rate = 1, t_min = 0, t_max = 10, tol = 10^-6)
}
\keyword{internal}
