% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SI.R
\name{SI}
\alias{SI}
\title{SI - Shadow Index}
\usage{
SI(B, G, R)
}
\arguments{
\item{B}{A raster layer object with the reflectance values for the Blue band.}

\item{G}{A raster layer object with the reflectance values for the Green band.}

\item{R}{A raster layer object with the reflectance values for the Red band.}
}
\value{
SI - Shadow Index
}
\description{
SI has main applications in forestry and crop monitoring. The characteristics of canopy shadow are associated by the total spectral radiance that is reflected from the canopy. Canopy shadow provides essential information about trees and plants arrangement.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
SI(x[[2]], x[[3]], x[[4]])

}
\references{
Rikimaru et al., 2002. Tropical forest cover density mapping. Tropical Ecology, 43, 39-47.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
