% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_tools.R
\name{summarize_sim}
\alias{summarize_sim}
\title{Summarize Simulations Results}
\usage{
summarize_sim(simulation_results, truth, ci_level = 0.95)
}
\arguments{
\item{simulation_results}{A \code{data.frame}, \code{tibble} or similar with
exactly two columns named \code{"param_est"} and \code{"param_var"} giving
the estimate of a parameter of interest and estimate of its variance (based
on a valid variance estimator specific to that parameter).Each row of this
data structure corresponds to the parameter estimate and variance for a
single iteration of several simulations.}

\item{truth}{A \code{numeric} value giving the true value of the parameter
of interest in the simulation setting.}

\item{ci_level}{A \code{numeric} value giving the level of the confidence
intervals to be generated around the parameter estimates and statistics
computed to summarize the simulation.}
}
\description{
Summarize Simulations Results
}
\examples{
n_sim <- 1000
n_obs <- c(100, 10000)
mu <- 2
sim_results <- lapply(n_obs, function(sample_size) {
  estimator_sim <- lapply(seq_len(n_sim), function(iter) {
    y_obs <- rnorm(sample_size, mu)
    est_param <- mean(y_obs)
    est_var <- var(y_obs) / sample_size
    estimate <- tibble::as_tibble(list(
      param_est = est_param,
      param_var = est_var
    ))
    return(estimate)
  })
  estimates <- do.call(rbind, estimator_sim)
  return(estimates)
})
sim_summary <- lapply(sim_results, summarize_sim, truth = mu)
}
