% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp9wH6ZH/file2ef7725fe91c
\name{nimNumeric}
\alias{nimNumeric}
\alias{numeric}
\title{Creates a numeric vector for use in NIMBLE DSL functions}
\usage{
nimNumeric(length = 0, value = 0, init = TRUE)
}
\arguments{
\item{length}{the length of the vector (default = 0)}

\item{value}{the initial value for each element of the vector (default = 0)}

\item{init}{logical, whether to initialize elements of the vector (default = TRUE)}
}
\description{
In a \code{nimbleFunction}, \code{numeric} is identical to \code{nimNumeric}
}
\details{
See the User Manual for usage examples.

When used in a \code{nimbleFunction} (in \code{run} or other member function), \code{numeric} is a synonym for \code{nimNumeric}.  When used with only the \code{length} argument, this behaves similarly to R's \code{integer} function.  NIMBLE provides additional arguments to control the initialization value and whether or not initialization will occur.  Using \code{init=FALSE} when initialization is not necessary can make compiled nimbleFunctions a bit faster.
}
\author{
Daniel Turek
}
\seealso{
\code{\link{integer}} \code{\link{matrix}} \code{\link{array}}
}

