% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is_numeric}
\alias{is_numeric}
\alias{is_nlist}
\alias{is_nlists}
\title{Is numeric, nlist or nlists}
\usage{
is_numeric(x)

is_nlist(x)

is_nlists(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A flag indicating whether x is a numeric object or inherits from S3 class nlist or nlists.
}
\description{
Test whether x is a numeric object,
\code{\link[=nlist_object]{nlist_object()}} or \code{\link[=nlists_object]{nlists_object()}}.
}
\section{Functions}{
\itemize{
\item \code{is_nlist}: Is nlist

\item \code{is_nlists}: Is nlists
}}

\examples{
# is_numeric
is_numeric(list(x = 1))
is_numeric(1)

# is_nlist
is_nlist(1)
is_nlist(list(x = 1))
is_nlist(nlist(x = 1))

# is_nlists
is_nlists(nlist(x = 1))
is_nlists(nlists(nlist(x = 2), nlist(x = 3.5)))
}
