### $Id: Oxide.R,v 1.1 2000/03/17 22:21:21 saikat Exp $
### A three-level nested design for the thickness of an oxide coating on a
### semiconductor.  The levels Wafer within Lot.  Source is an outer factor.
### Data set 4.4 from "SAS System for Mixed Models".
"Oxide" <-
  structure(list(
  Source = structure(factor(c(1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
    2, 2, 2), levels=1:2), class = "factor", .Label = c("1", "2")),
Lot = structure(factor(c(1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 
  8, 8, 8, 8, 8, 8, 8, 8), levels=1:8), class = "factor",
  .Label = c("1", "2", "3", "4", "5", "6", "7", "8")),
Wafer = structure(factor(c(1, 
  1, 1, 2, 2, 2, 3, 3, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 1, 1, 1, 2, 
  2, 2, 3, 3, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 1, 1, 1, 2, 2, 2, 3, 
  3, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 1, 
  1, 1, 2, 2, 2, 3, 3, 3), levels=1:3), class = "factor",
  .Label = c("1", "2", "3")),
Site = structure(factor(c(1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3), levels=1:3), class = "factor", .Label = c("1", "2", "3")),
Thickness = c(2006, 
  1999, 2007, 1980, 1988, 1982, 2000, 1998, 2007, 1991, 1990, 1988, 
  1987, 1989, 1988, 1985, 1983, 1989, 2000, 2004, 2004, 2001, 1996, 
  2004, 1999, 2000, 2002, 1997, 1994, 1996, 1996, 2000, 2002, 1987, 
  1990, 1995, 2013, 2004, 2009, 2023, 2018, 2010, 2020, 2023, 2015, 
  2032, 2036, 2030, 2018, 2022, 2026, 2009, 2010, 2011, 1984, 1993, 
  1993, 1992, 1992, 1990, 1996, 1993, 1987, 1996, 1989, 1996, 1997, 
  1993, 1996, 1990, 1989, 1992)),
class = c("nmGroupedData", "groupedData", "data.frame"),
row.names = 1:72,
formula = Thickness ~ 1 | Lot/Wafer,
formulaList = list(Lot = ~Lot, Wafer = ~Wafer),
labels = list(y = "Thickness of oxide layer"),
outer = ~ Source,
order.groups = list(Lot = TRUE, Wafer = TRUE),
FUN = function (x) mean(x, na.rm = TRUE))
