% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MULTI.initial_helper.R
\name{getMULTI.initial}
\alias{getMULTI.initial}
\title{Compute Initial Values for Parameters of Multivariate Latent Growth Curve Models or Latent Change Score Models}
\usage{
getMULTI.initial(dat, t_var, y_var, curveFun, records, res_scale, res_cor)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables
with repeated measurements and occasions for multiple longitudinal outcomes. It takes the value passed from \code{getMGM()}.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding outcome variable at each study wave. It takes the value passed from \code{getMGM()}.}

\item{y_var}{A vector of strings, with each element representing the prefix for column names corresponding to a
particular outcome variable at each study wave. It takes the value passed from \code{getMGM()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getMGM()}.}

\item{records}{A list of numeric vectors, with each vector specifying the indices of the observed study waves for
the corresponding outcome variable. It takes the value passed from \code{getMGM()}.}

\item{res_scale}{A numeric vector with each element representing the scaling factor for the initial calculation of the residual
variance. These values should be between \code{0} and \code{1}, exclusive. It takes the value passed from \code{getMGM()}.}

\item{res_cor}{A numeric value or vector for user-specified residual correlation between any two longitudinal outcomes to calculate
the corresponding initial value. It takes the value passed from \code{getMGM()}.}
}
\value{
A list containing the initial values for the parameters in the multivariate latent growth curve
model or a latent change score model growth curve model.
}
\description{
This function computes the initial values for the parameters for a multivariate latent growth curve model
or a latent change score model.
}
