% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_GenSA}
\alias{simdesign_GenSA}
\title{Add a Simulated Annealing simdesign to a nl object}
\usage{
simdesign_GenSA(nl, par = NULL, evalcrit = 1, control = list(),
  nseeds = 1)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{par}{optional vector of start values for each parameter defined in variables of experiment}

\item{evalcrit}{position of evaluation criterion within defined NetLogo metrics of nl experiment}

\item{control}{list with further arguments passed to the GenSA function (see ?GenSA for details)}

\item{nseeds}{number of seeds for this simulation design}
}
\value{
simdesign S4 class object
}
\description{
Add a Simulated Annealing simdesign to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.

Variables in the experiment variable list need to provide a numeric distribution with min and max (e.g. list(min=1, max=4)).

The GenSA simdesign generates a simulated Annealing experiment within the defined min and max parameter boundaries
that are defined in the variables field of the experiment object within the nl object.
The evalcrit reporter defines the evaluation criterion for the simulated annealing procedure.
The reporter is defined within the experiment metrics vector.
For the simulated annealing function we only refer to the position of the reporter that we want to use for evaluation.
The function uses the GenSA package to set up a Simulated Annealing function.
For details on the GenSA function parameters see ?GenSA
Finally, the function reports a simdesign object.

Simulated Annealing simdesigns can only be executed using the \link[nlrx]{run_nl_dyn} function instead of \link[nlrx]{run_nl_all} or \link[nlrx]{run_nl_one}.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_lhs
nl@simdesign <- simdesign_GenSA(nl=nl,
                                 par=NULL,
                                 evalcrit=1,
                                 control=list(max.time = 600),
                                 nseeds=1)


}
