% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{MNlogitf}
\alias{MNlogitf}
\alias{MNdogitf}
\title{\code{MNlogitf} or \code{MNdogitf} returns log-likelihood(LL) expression for discrete equations of "logit" or "dogit" model.}
\usage{
MNlogitf(ffor, transform = FALSE, separatenmm = FALSE, weight_disc = FALSE)

MNdogitf(
  ffor,
  transform = FALSE,
  separatenmm = FALSE,
  weight_disc = FALSE,
  ppardogit = NULL
)
}
\arguments{
\item{ffor}{Discrete choice equations.}

\item{transform}{if \code{TRUE}, quantile transformation (normal) is applied.}

\item{separatenmm}{if \code{TRUE}, equation specific LL is calculated}

\item{weight_disc}{if \code{TRUE}, equations will include equation specific weights.}

\item{ppardogit}{"dogit" parameters only used in MNdogitf}
}
\value{
\item{formula}{simplified LL for each equation or joint}
\item{probs}{probability expression unsimplified}
\item{expr}{LL string simplified }
\item{formulat}{unsimplified log(P), only if transform is TRUE}
\item{probt}{unsimplified P with quantile transformation qnorm(ifelse(P)), only if transform is TRUE}
\item{expreteso}{unsimplified pnorm((qnorm(P)-mean)/sd), only if transform is TRUE}
\item{probte}{qnorm(P)}
\item{tval}{If quantile transformation is applied}
\item{sume}{Denominator of logit probability}
}
\description{
\code{MNlogitf} or \code{MNdogitf} returns log-likelihood(LL) expression for discrete equations of "logit" or "dogit" model.
}
\section{Functions}{
\itemize{
\item \code{MNlogitf}: returns log-likelihood(LL) expression for discrete equations of "logit" model.

\item \code{MNdogitf}: returns log-likelihood(LL) expression for discrete equations of "dogit" model.
}}

\examples{
eq_d <- c("ASC1 * 1 + B11_dur * dur_1" , "ASC2 * 1 + B12_dur * dur_2",
"ASC3 * 1 + B13_dur * dur_3 + B20_cost * cost_3 + B53_parkman * PbAvl_3",
"ASC4 * 1 + B14_dur * dur_4 + B20_cost * cost_4 + B34_serv * servIdx_4 + B44_stop * stopUs1R1_4")
parl <- c(paste0("ASC", 1:4), paste0("B1", 1:4, "_dur"), "B20_cost", "B53_parkman", "B34_serv",
"B44_stop")
disc_par <- get_par(parl, eq_d)
ffor <- disc_par$cheqs0
res_l <- MNlogitf(ffor, separatenmm=FALSE, transform=FALSE)
res_d <- MNdogitf(ffor, separatenmm=FALSE, transform=FALSE)
}
