% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{f_create}
\alias{f_create}
\title{\code{f_create} creates functions for log-likelihood of different models.}
\usage{
f_create(
  mn,
  data,
  fixed = 0,
  cheqs0 = NULL,
  separatenmm = FALSE,
  probt = NULL,
  tformula = NULL,
  hessian = NULL,
  transform = TRUE,
  sume = NULL
)
}
\arguments{
\item{mn}{Expression, can be a list of equations.}

\item{data}{Name of the data frame with which the function will be evaluated.}

\item{fixed}{Integer, which parameter is fixed to be 0.}

\item{cheqs0}{If continuous are supplied, include the expressions of errors.}

\item{separatenmm}{if \code{TRUE}, separate log-likelihood for each equations is produced.}

\item{probt}{Expressions of un-simplified probabilities with quantile transformation(qnorm(ifelse(P))).}

\item{tformula}{unsimplified log(P)}

\item{hessian}{Adds lines to check the Hessian, hessian should be the name of hessian function.}

\item{transform}{if \code{TRUE}, adds lines to check conditional means}

\item{sume}{Expression of summed likelihoods.}
}
\value{
Function.
}
\description{
\code{f_create} creates functions for log-likelihood of different models.
}
\examples{
eq_d <- c("ASC1 * 1 + B11_dur * dur_1" , "ASC2 * 1 + B12_dur * dur_2",
"ASC3 * 1 + B13_dur * dur_3 + B20_cost * cost_3 + B53_parkman * PbAvl_3",
"ASC4 * 1 + B14_dur * dur_4 + B20_cost * cost_4 + B34_serv * servIdx_4 + B44_stop * stopUs1R1_4")
parl <- c(paste0("ASC", 1:4), paste0("B1", 1:4, "_dur"), "B20_cost", "B53_parkman", "B34_serv",
"B44_stop")
obj <- get_par(parl, eq_d)
ffor <- obj$cheqs0
res <- MNlogitf(ffor, separatenmm=FALSE, transform=FALSE)
ff <- f_create(res$formula, data="data", fixed=1)
}
