% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_extend.R
\name{raster_extend}
\alias{raster_extend}
\title{Wrapper for \code{raster::extend} on \code{stars} objects}
\usage{
raster_extend(x, y)
}
\arguments{
\item{x}{A \code{stars} object}

\item{y}{An \code{sf} object from which an extent can be extracted, or any other object accepted by \code{raster::extend}}
}
\value{
An extended \code{stars} object
}
\description{
This is a wrapper around \code{raster::extend}, to apply the function on \code{stars} objects without needing to convert to and from a \code{Raster*} object.
}
\examples{
library(stars)
data(dem)
e = st_as_sf(dem)
e = st_union(e)
e = st_buffer(e, 1000)
dem_extend = raster_extend(dem, st_sf(e))
dem_extend[is.na(dem_extend)] = -1
plot(dem)
plot(dem_extend)

}
