% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{rseg}
\alias{rseg}
\title{Generation of Points under Segregation of Two Classes}
\usage{
rseg(n1, n2, r1, r2, X1.init = NULL, X2.init = NULL)
}
\arguments{
\item{n1, n2}{Positive integers representing the number of class 1 and class 2 (i.e. \eqn{X_1} and \eqn{X_2}) points
to be generated under the segregation pattern.}

\item{r1, r2}{Positive real numbers representing the radius of attraction within class, i.e. radius of the
circle center and generated points are from the same class.}

\item{X1.init, X2.init}{2D points representing the initial points for the segregated classes, default=\code{NULL}
for both. If both \code{X1.init=NULL} and \code{X2.init=NULL}, both \code{X1.init} and \code{X2.init} are generated uniformly in the
unit square.
If only \code{X1.init=NULL}, \code{X1.init} is the sum of a point uniformly generated in the unit square and \code{X2.init} and
if only \code{X2.init=NULL}, \code{X2.init} is the sum of a point uniformly generated in the unit square and \code{X1.init}.
The initial points are
marked with crosses in the plot of the points.}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{"2c"} for the 2-class pattern of segregation of the two classes}
\item{type}{The type of the point pattern}
\item{parameters}{Radial (i.e. circular) within class radii of segregation, \code{r1} and \code{r2},
controlling the level of segregation}
\item{lab}{The class labels of the generated points, it is 1 class 1 or \eqn{X_1} points and 
2 for class 2 or \eqn{X_2} points}
\item{init.cases}{The initial points for class 1 and class 2, one initial point for each class.}
\item{gen.points}{The output set of generated points (i.e. class 1 and class 2 points) segregated 
from each other.}
\item{ref.points}{The input set of reference points, it is \code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated class 1 and class 2 points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and
the initial points}
}
\description{
An object of class \code{"Patterns"}.

Generates \code{n_i} 2D points from class \eqn{j} with parameters  \eqn{r_j} for \eqn{j=1,2}.
The generated points are from two different classes which are segregated from each other.
The pattern generation starts with the initial points \code{X1.init} and \code{X2.init} (with default=\code{NULL} for both).
If both \code{X1.init=NULL} and \code{X2.init=NULL}, both \code{X1.init} and \code{X2.init} are generated uniformly in the unit square.
If only \code{X1.init=NULL}, \code{X1.init} is the sum of a point uniformly generated in the unit square and \code{X2.init} and
if only \code{X2.init=NULL}, \code{X2.init} is the sum of a point uniformly generated in the unit square and \code{X1.init}.
After the initial points from each class are available, \eqn{n_j} points from class \eqn{j} are generated
as \code{Xj[i,]<-Xj[(i-1),]+ru*c(cos(tu),sin(tu))}  
where \code{ru<-runif(1,0,rj)} and \code{tu<-runif(1,0,2*pi)} for \eqn{i=2,\ldots,n_j}
with \code{Xj[1,]=Xj.init} for \eqn{j=1,2}.
That is, at each step the new point in class \eqn{j} is generated within a circle with radius equal to \eqn{r_j}
(uniform in the polar coordinates).
Note that, the level of segregation is stronger if the initial points are further apart, and the level
of segregation increases as the radius values gets smaller.
}
\examples{
n1<-20;  #try also n1<-10; n1<-100;
n2<-20; #try also n1<-40; n2<-50

r1<-.3; r2<-.2

#data generation
Xdat<-rseg(n1,n2,r1,r2) #labeled data
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#with one initial point
X1init<-c(3,2)

Xdat<-rseg(n1,n2,r1,r2,X1.init=X1init)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#with two initial points
X1init<-c(3,2)
X2init<-c(4,2)

Xdat<-rseg(n1,n2,r1,r2,X1init,X2init)
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat) 

}
\seealso{
\code{\link{rassoc}}
}
\author{
Elvan Ceyhan
}
