% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{tocher.cor}
\alias{tocher.cor}
\title{Tocher's randomized correction to the exact \eqn{p}-value}
\usage{
tocher.cor(ptable, pval)
}
\arguments{
\item{ptable}{Probability of the contingency table under the null hypothesis using the hypergeometric 
distribution for Fisher's exact test.}

\item{pval}{Table inclusive \eqn{p}-value for Fisher's exact test on the contingency table.}
}
\value{
A modified \eqn{p}-value based on the Tocher's randomized correction.
}
\description{
Tocher's modification is used for the Fisher's exact test on the contingency tables making it less conservative,
by including the probability for the current table based on a randomized test
(\insertCite{tocher:1950;textual}{nnspat}). It is applied When table-inclusive version of the \eqn{p}-value,
\eqn{p^>_{inc}}, is larger, but table-exclusive version, \eqn{p^>_{exc}}, is less than the level of the test \eqn{\alpha},
a random number, \eqn{U}, is generated from uniform distribution in \eqn{(0,1)}, and if \eqn{U \leq (\alpha-p^>_{exc})/p_t},
\eqn{p^>_{exc}} is used, otherwise \eqn{p_{inc}} is used as the \eqn{p}-value.

Table-inclusive and exclusive \eqn{p}-values are defined as follows. 
Let the probability of the contingency table itself
be \eqn{p_t=f(n_{11}|n_1,n_2,c_1;\theta)} where \eqn{\theta} is the odds ratio
under the null hypothesis (e.g. \eqn{\theta=1} under independence) and 
\eqn{f} is the probability mass function of the hypergeometric distribution.
In testing the one-sided alternative \eqn{H_o:\,\theta=1} versus \eqn{H_a:\,\theta>1},
let \eqn{p=\sum_S f(t|n_1,n_2,c_1;\theta=1)}, then
with \eqn{S=\{t:\,t \geq n_{11}\}}, we get the \emph{table-inclusive version} which is denoted as \eqn{p^>_{inc}}
and with \eqn{S=\{t:\,t> n_{11}\}}, we get the \emph{table-exclusive version}, denoted as \eqn{p^>_{exc}}.

See (\insertCite{ceyhan:exact-NNCT;textual}{nnspat}) for more details.
}
\examples{
ptab<-.03
pval<-.06
tocher.cor(ptab,pval)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{prob.nnct}}, \code{\link{exact.pval1s}}, and \code{\link{exact.pval2s}}
}
\author{
Elvan Ceyhan
}
