% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{varTkinv.sim}
\alias{varTkinv.sim}
\title{Simulated Variance of Cuzick and Edwards \eqn{T_k^{inv}} Test statistic}
\usage{
varTkinv.sim(dat, k, cc.lab, Nsim = 1000, case.lab = NULL)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,}

\item{k}{Integer specifying the number of the closest controls to subject \eqn{i}.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{Nsim}{The number of simulations, i.e., the number of resamplings under the RL scheme to estimate the 
variance of \eqn{T_k^{inv}}}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}
}
\value{
The simulation estimated variance of Cuzick and Edwards \eqn{T_k^{inv}} test statistic for disease clustering
}
\description{
This function estimates the variance of Cuzick and Edwards \eqn{T_k^{inv}} test statistic by Monte Carlo simulations
under the RL hypothesis.

The exact variance of \eqn{T_k^{inv}} is currently not available and (\insertCite{cuzick:1990;textual}{nnspat}) say
that "The permutational variance of \eqn{T_k^{inv}} becomes unwieldy for \eqn{k > 1} and is more easily simulated", hence
we estimate the variance of \eqn{T_k^{inv}} by RL of cases and controls to the given point data.

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly. The argument \code{Nsim} represents the number of resamplings (without replacement) in the
RL scheme, with default being \code{1000}. 

See (\insertCite{cuzick:1990;textual}{nnspat}).

See the function \code{\link{ceTkinv}} for the details of the \eqn{T_k^{inv}} test.
}
\examples{
set.seed(123)
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)
n1<-sum(cls==1)
k<-2

Nmc<-1000
varTkinv.sim(Y,k,cls,Nsim=Nmc)

set.seed(1)
varTrun.sim(Y,cls,Nsim=Nmc)
set.seed(1)
varTkinv.sim(Y,k=1,cls,Nsim=Nmc)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
varTkinv.sim(Y,k,fcls,Nsim=Nmc,case.lab="a")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTkinv}} and \code{\link{EV.Tkinv}}
}
\author{
Elvan Ceyhan
}
