% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsRowColSums}
\alias{funsRowColSums}
\alias{row.sum}
\alias{col.sum}
\title{Functions for row and column sums of a matrix}
\usage{
row.sum(ct)

col.sum(ct)
}
\arguments{
\item{ct}{A matrix, in particular a contingency table}
}
\value{
\code{row.sum} returns the row sums of \code{ct} as a vector
\code{col.sum} returns the column sums of \code{ct} as a vector
}
\description{
Two functions: \code{row.sum} and \code{col.sum}.

\code{row.sum} returns the row sums of a given matrix (in particular a contingency table) as a vector and 
\code{col.sum} returns the column sums of a given matrix as a vector. \code{row.sum} is equivalent to 
\code{\link[base]{rowSums}} function and \code{col.sum} is equivalent to \code{\link[base]{colSums}}
function in the \code{base} package.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

row.sum(ct)
rowSums(ct)

col.sum(ct)
colSums(ct)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

row.sum(ct)
rowSums(ct)

col.sum(ct)
colSums(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

row.sum(ct)
rowSums(ct)

col.sum(ct)
colSums(ct)

}
\seealso{
\code{\link[base]{rowSums}} and \code{\link[base]{colSums}}
}
\author{
Elvan Ceyhan
}
