% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_storm_data}
\alias{download_storm_data}
\title{Download storm data file for a given year}
\usage{
download_storm_data(year, file_type = "details")
}
\arguments{
\item{year}{A four-digit numeric or character string giving the year for which
the user would like to download data.}

\item{file_type}{A character string specifying the type of file you would
like to pull. Choices include: "details" (the default), "fatalities", or
"locations".}
}
\description{
This function takes a year for which you want to download storm data,
checks to see if it's already been downloaded and cached, and, if not,
downloads and caches it from the NOAA's online storm events files.
}
\note{
This function caches downloaded storm data into an object called \code{lst}
that persist throughout the R session but is deleted at the end of the R
session (as long as the R history is not saved at the end of the session).
This saves time if the user uses the storm data from the same year for
several commands.
}
