% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopping-rules.R
\name{ts_change}
\alias{ts_change}
\title{Time series change stopping rule}
\usage{
ts_change(x, reltol = 1e-04, tol = 1e-12)
}
\arguments{
\item{x}{\code{numeric} vector of last \eqn{\gamma_n} values, as selected by the
function passed to \code{\link[=noisyCE2]{noisyCE2()}} through the argument \code{stopwindow}.}

\item{reltol}{relative changes smaller than \code{tol} stop the algorithm.}

\item{tol}{changes smaller than \code{tol} stop the algorithm.}
}
\value{
A \code{numeric} indicating whether the algorithm has converged:
\item{0}{the algorithm has converged.}
\item{1}{the algorithm has not converged.}
}
\description{
Deterministic stopping rule based on the last change in the value of
\eqn{\gamma_n}. Changes smaller than \code{tol}, or relative changes
smaller than \code{reltol} stop the algorithm. This criterion is suitable
only in case of deterministic objective functions.
}
\seealso{
Other stopping rules: \code{\link{geweke}}
}
\concept{stopping rules}
