% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance_matrices_counts.R
\name{calculate_distance_matrices_counts}
\alias{calculate_distance_matrices_counts}
\title{Calcualte the distance matrices using the count matrix}
\usage{
calculate_distance_matrices_counts(
  expression.matrix,
  method = "correlation_pearson",
  n.elements.per.window = NULL,
  nstep = NULL,
  nstep.frac = 0.05
)
}
\arguments{
\item{expression.matrix}{expression matrix, can be normalized or not}

\item{method}{one of the correlation or distance metrics to be used,
defaults to pearson correlation; list of all methods in
get_methods_correlation_distance()}

\item{n.elements.per.window}{number of elements to have in a window,
default 10\% of the number of rows}

\item{nstep}{step size to slide across, default 1\% of n.elements.per.window}

\item{nstep.frac}{an alternative way to specify the step size, as a fraction of
the window length; default is 5\%}
}
\value{
A list with three elements: the first element is the expression matrix,
        as supplied; the other two are the abundance and distance matrix;
        they have the same # of columns as the expression matrix,
        and n.elements.per.window*nstep rows.
}
\description{
This function generates an average correlation/distance coefficient
for every sliding window, for each sample in the expression matrix.
That is done by comparing the distribution of genes in each window across samples.
}
\examples{
calculate_distance_matrices_counts(
    expression.matrix = matrix(1:100, ncol=5),
    method="correlation_pearson",
    n.elements.per.window=3)
}
