% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_amenity_sf.R
\name{geo_amenity_sf}
\alias{geo_amenity_sf}
\title{Geocode amenities in \CRANpkg{sf} format}
\usage{
geo_amenity_sf(
  bbox,
  amenity,
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  progressbar = TRUE,
  custom_query = list(),
  strict = FALSE,
  points_only = TRUE
)
}
\arguments{
\item{bbox}{The bounding box (viewbox) used to limit the search. It could be:
\itemize{
\item A numeric vector of \strong{longitude} (\code{x}) and \strong{latitude} (\code{y})
\verb{(xmin, ymin, xmax, ymax)}. See \strong{Details}.
\item A \code{\link[sf:sf]{sf}} or \code{\link[sf:sfc]{sfc}} object.
}}

\item{amenity}{A \code{character} (or a vector of \code{character}s) with the
amenities to be geolocated (i.e. \code{c("pub", "restaurant")}). See
\link{osm_amenities}.}

\item{limit}{Maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_addresses}{Return input addresses with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{strict}{Logical \code{TRUE/FALSE}. Force the results to be included inside
the \code{bbox}. Note that Nominatim default behavior may return results located
outside the provided bounding box.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{\link[sf:sf]{sf}} object with the results.
}
\description{
This function search \link[=osm_amenities]{amenities} as defined by OpenStreetMap
on a restricted area defined by a bounding box in the form
\verb{(<xmin>, <ymin>, <xmax>, <ymax>)}.  This function returns the spatial
object associated with the query using \CRANpkg{sf}, see \code{\link[=geo_amenity]{geo_amenity()}} for
retrieving the data in \code{\link[tibble:tibble]{tibble}} format.
}
\details{
Bounding boxes can be located using different online tools, as
\href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.

For a full list of valid amenities see
\url{https://wiki.openstreetmap.org/wiki/Key:amenity} and \link{osm_amenities}.

See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item Administrative areas, major buildings and the like will be
returned as polygons.
\item Rivers, roads and their like as lines.
\item Amenities may be points even in case of a \code{points_only = FALSE} call.
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Usera, Madrid

library(ggplot2)
mad <- geo_lite_sf("Usera, Madrid, Spain", points_only = FALSE)


# Restaurants, pubs and schools

rest_pub <- geo_amenity_sf(mad, c("restaurant", "pub", "school"),
  limit = 50
)

if (any(!sf::st_is_empty(rest_pub))) {
  ggplot(mad) +
    geom_sf() +
    geom_sf(data = rest_pub, aes(color = query, shape = query))
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other amenity: 
\code{\link{geo_amenity}()},
\code{\link{osm_amenities}}

Geocoding: 
\code{\link{geo_address_lookup}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_lite}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct}()},
\code{\link{geo_lite_struct_sf}()}

Get \code{\link[sf:sf]{sf}} objects: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{amenity}
\concept{geocoding}
\concept{spatial}
