% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superset.R
\name{fold.character}
\alias{fold.character}
\title{Fold Character}
\usage{
\method{fold}{character}(x, ..., meta = match.fun("meta")(x, ...),
  simplify = TRUE, sort = TRUE, subset)
}
\arguments{
\item{x}{character}

\item{...}{unquoted grouping variables}

\item{meta}{pre-folded metadata}

\item{simplify}{whether to simplify the result}

\item{sort}{whether to sort the result}

\item{subset}{length-one character: a condition for filtering results, e.g. 'EVID == 1'}
}
\value{
folded
}
\description{
Folds character, treating \code{x} as a model name.
}
\examples{
library(magrittr)
library(fold)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% fold(ID,TIME,subset='MDV==0') \%>\% head
}
\keyword{internal}
