% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize.R
\name{minimize.nonneg.cg}
\alias{minimize.nonneg.cg}
\title{Non-Negative CG Minimizer}
\usage{
minimize.nonneg.cg(evaluate_function, evaluate_gradient, x0, tol = 1e-04,
  maxnfeval = 1500, maxiter = 200, decr_lnsrch = 0.5,
  lnsrch_const = 0.01, max_ls = 20, extra_nonneg_tol = FALSE,
  nthreads = 1, verbose = FALSE, ...)
}
\arguments{
\item{evaluate_function}{function(x, ...) objective evaluation function}

\item{evaluate_gradient}{function(x, ...) gradient evaluation function}

\item{x0}{Starting point. Must be a feasible point (>=0). Be aware that it might be modified in-place.}

\item{tol}{Tolerance for <gradient, direction>}

\item{maxnfeval}{Maximum number of function evaluations}

\item{maxiter}{Maximum number of CG iterations}

\item{decr_lnsrch}{Number by which to decrease the step size after each unsuccessful line search}

\item{lnsrch_const}{Acceptance parameter for the line search procedure}

\item{max_ls}{Maximum number of line search trials per iteration}

\item{extra_nonneg_tol}{Ensure extra non-negative tolerance by explicitly setting elements that
are <=0 to zero at each iteration}

\item{nthreads}{Number of parallel threads to use (ignored if the package was installed from CRAN)}

\item{verbose}{Whether to print convergence messages}

\item{...}{Extra parameters to pass to the objective and gradient functions}
}
\description{
Minimize a differentiable function subject to all the variables being non-negative
(i.e. >= 0), using a Conjugate-Gradient algorithm based on a modified Polak-Ribiere-Polyak formula (see
reference at the bottom for details).
}
\details{
The underlying C function can also be called directly from Rcpp with `R_GetCCallable` (see example of such usage
in the source code of the 'zoo' package).
}
\examples{
fr <- function(x) {   ## Rosenbrock Banana function
  x1 <- x[1]
  x2 <- x[2]
  100 * (x2 - x1 * x1)^2 + (1 - x1)^2
}
grr <- function(x) { ## Gradient of 'fr'
  x1 <- x[1]
  x2 <- x[2]
  c(-400 * x1 * (x2 - x1 * x1) - 2 * (1 - x1),
    200 *      (x2 - x1 * x1))
}
minimize.nonneg.cg(fr, grr, x0 = c(0,2))
}
\references{
Li, C. (2013). A conjugate gradient type method for the nonnegative constraints optimization problems. Journal of Applied Mathematics, 2013.
}
