% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{methods}
\name{rfromPsi}
\alias{rfromPsi}
\alias{psifromR}
\title{Convertion between Pearson correlation and the non paramtric concordance coefficient}
\usage{
rfromPsi(psi)

psifromR(r)
}
\arguments{
\item{psi}{a (vector of) non paramtric concordance coefficient(s)}

\item{r}{a (vector of) Pearson correlation coefficient(s)}
}
\value{
A (vector of) corresponding Pearson correlation coefficient(s).
}
\description{
Convertion between Pearson correlation and the non paramtric concordance coefficient
}
\details{
The convertion is performed following the relationship described by Rothery (1979).
\code{2*cos(pi*(1-psi))-1}
}
\examples{

#Generate a matrix without concordance
matRandom <- matrix(rnorm(30),10,3)
result<-concordance.test(matRandom) 
getPsi(result) #concordance coefficient
result$ci      #95\% confidence interval

#Corresonding Pearson correlation 
rfromPsi(getPsi(result))
rfromPsi(result$ci)

#Plot the relation between Pearson correlation and the nonparamatric concordance coefficient.
r<-seq(-1,1,0.01)
psi<-psifromR(r)
plot(r,psi,type='l',xlab="Pearson correlation", ylab="nonparametric concordance")

}
\references{
Rothery, P. 'A nonparametric measure of intraclass correlation', Biometrika, 66, 3, 629-639  (1979).
}
\seealso{
Other concordance functions: \code{\link{coef}},
  \code{\link{concordance.test}}, \code{\link{getPsi}}
}
