% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.not}
\alias{plot.not}
\title{Plot a 'not' object}
\usage{
\method{plot}{not}(x, ...)
}
\arguments{
\item{x}{An object of class 'not', returned by \code{\link{not}}.}

\item{...}{Further parameters which may be passed to \code{\link{predict.not}} and \code{\link{features}}.}
}
\description{
Plots the input vector used to generate 'not' object \code{x} with the signal fitted with \code{\link{predict.not}}.
}
\examples{
# **** Piecewisce-constant mean with Gaussian noise.
x <- c(rep(0, 100), rep(1,100)) + rnorm(100)
# *** identify potential locations of the change-points
w <- not(x, contrast = "pcwsConstMean")
# *** when 'cpt' is omitted, 'features' function is used internally 
# to choose change-points locations
plot(w)
# *** estimate and plot the signal specifying the location of the change-point
plot(w, cpt=100)
}
\seealso{
\code{\link{predict.not}} \code{\link{not}}  \code{\link{features}}
}

