#' @title nowcasting and create Real-Time data basis
#'
#' @description Methods and tools for nowcasting Brazilian economic time series. 
#' It allows extract information in real time, creating a real time data base; 
#' estimate relationship between macroeconomic variables via estimation of dynamic factors; 
#' forecast time series in previous periods of reference; 
#' forecast time series in the current period of reference (nowcasting); 
#'
#' The methodology is based on \emph{Giannone, Domenico, Lucrezia Reichlin, and David Small. "Nowcasting: The real-time informational content of macroeconomic data." Journal of Monetary Economics 55.4 (2008): 665-676.}
#' This is one of the seminal works in the nowcasting area. Some functions are adaptations and translations of this paper's \emph{replication files} avaible in MATLAB and RATS. One can found these \emph{replication files} in the following url:
#' \url{https://www.newyorkfed.org/research/economists/giannone/pub}
#'
#' @note The authors would like to thank the support by the Getulio 
#' Vargas Foundation (FGV).
#' 
#' @author Daiane Mattos \email{daiane.mattos@fgv.br},
#'         Guilherme Branco \email{guilherme.branco@fgv.br},
#'         Pedro Costa Ferreira \email{pedro.guilherme@fgv.br}, 
#'         
#'         
#'
#' @docType package
#' @name nowcasting
#'
NULL