scbandwidth <-
  function(bw = stop("scbandwidth:argument 'bw' missing"),
           bwmethod = c("cv.ls", "manual"),
           bwscaling = FALSE,
           bwtype = c("fixed","generalized_nn","adaptive_nn"),
           ckertype = c("gaussian", "epanechnikov","uniform"), 
           ckerorder = c(2,4,6,8),
           ukertype = c("aitchisonaitken", "liracine"),
           okertype = c("wangvanryzin", "liracine"),
           fval = NA,
           ifval = NA,
           nobs = NA,
           numimp = NA,
           fval.vector = NA,
           xdati = stop("scbandwidth:argument 'xdati' missing"),
           ydati = stop("scbandwidth:argument 'ydati' missing"),
           zdati = NULL,
           xnames = character(length(bw)),
           ynames = character(1),
           znames = NULL,
           sfactor = NA, bandwidth = NA,
           rows.omit = NA,
           bandwidth.compute = TRUE){

  ndim = length(bw)
  bwmethod = match.arg(bwmethod)
  bwtype = match.arg(bwtype)
  ckertype = match.arg(ckertype)

  if(missing(ckerorder))
    ckerorder = 2
  else if (ckertype == "uniform")
    warning("ignoring kernel order specified with uniform kernel type")
  else {
    kord = eval(formals()$ckerorder) 
    if (!any(kord == ckerorder))
      stop("ckerorder must be one of ", paste(kord,collapse=" "))
  }


  ukertype = match.arg(ukertype)
  okertype = match.arg(okertype)

  tdati <- zdati

  if(is.null(zdati))
    tdati <- xdati

  porder = switch( ckerorder/2, "Second-Order", "Fourth-Order", "Sixth-Order", "Eighth-Order" )

  if (!identical(sfactor,NA)){
    sumNum <- sapply(1:ndim, function(i) {
      if (tdati$icon[i])
        return(sfactor[i])

      if (tdati$iord[i])
        return(oMaxL(tdati$all.nlev[[i]], kertype = okertype))
      
      if (tdati$iuno[i])
        return(uMaxL(tdati$all.nlev[[i]], kertype = ukertype))
    })
  } else {
    sumNum <- NA
  }

  if (length(rows.omit) == 0)
    rows.omit <- NA

  
  mybw = list(
    bw=bw,
    method = bwmethod,
    pmethod = switch( bwmethod,
      manual = "Manual",
      cv.ls = "Least Squares Cross-Validation" ),
    fval = fval,
    ifval = ifval,
    scaling = bwscaling,
    pscaling = ifelse(bwscaling, "Scale Factor(s)", "Bandwidth(s)"),
    type = bwtype,
    ptype = switch( bwtype,
      fixed = "Fixed",
      generalized_nn = "Generalized Nearest Neighbour",
      adaptive_nn = "Adaptive Nearest Neighbour" ),
    ckertype = ckertype,    
    ckerorder = ckerorder,
    pckertype = switch(ckertype,
      gaussian = paste(porder,"Gaussian"),
      epanechnikov =  paste(porder,"Epanechnikov"),
      uniform = "Uniform"),
    ukertype = ukertype,
    pukertype = switch( ukertype,
      aitchisonaitken = "Aitchison and Aitken",
      liracine = "Li and Racine"),
    okertype = okertype,
    pokertype = switch( okertype,
      wangvanryzin = "Wang and Van Ryzin",
      liracine = "Li and Racine"),
    nobs = nobs,
    ndim = ndim,
    ncon = sum(xdati$icon),
    nuno = sum(xdati$iuno),
    nord = sum(xdati$iord),
    icon = xdati$icon,
    iuno = xdati$iuno,
    iord = xdati$iord,
    xnames = xnames,
    ynames = ynames,
    znames = znames,
    xdati = xdati,
    ydati = ydati,
    zdati = zdati,
    xmcv = mcvConstruct(xdati),
    sfactor = list(z = sfactor),
    bandwidth = list(z = bandwidth),
    sumNum = list(z = sumNum),
    dati = list(x = xdati, y = ydati, z = zdati),
    varnames = list(x = xnames, y = ynames, z = znames),
    vartitle = list(x = "Explanatory", y = "Dependent", z = "Explanatory"),
    vartitleabb = list(x = "Exp.", y = "Dep.", z = "Exp."),
    rows.omit = rows.omit,
    nobs.omit = ifelse(identical(rows.omit,NA), 0, length(rows.omit)))

  mybw$klist <-
    list(z =
         list(ckertype = ckertype,
              pckertype = mybw$pckertype))
  
  if(!bandwidth.compute)
    mybw$pmethod <- "Manual"

  class(mybw) = "scbandwidth"
  mybw
  
}

as.double.scbandwidth <- function(x, ...){
  x$bw
}

print.scbandwidth <- function(x, digits=NULL, ...){
  cat("\nSmooth Coefficient Model",
      "\nRegression Data (",x$nobs," observations, ",x$ndim," variable(s)):\n\n",sep="")
  print(matrix(x$bw,ncol=x$ndim,dimnames=list(paste(x$pscaling,":",sep=""),x$xnames)))

  cat(genBwSelStr(x))
  cat(genBwKerStrs(x))
  
  cat("\n\n")
  if(!missing(...))
    print(...,digits=digits)
  invisible(x)
}

plot.scbandwidth <- function(...) { npplot(...)  }
predict.scbandwidth <- function(...) { eval(npscoef(...), env = parent.frame()) }

summary.scbandwidth <- function(object, ...){
  cat("\nSmooth Coefficient Regression",
      "\nRegression Data (",object$nobs," observations, ",object$ndim," variable(s)):\n",sep="")

  cat(genOmitStr(object))
  cat(genBwSelStr(object))

  cat('\n')
  cat(genBwScaleStrs(object))

  cat(genBwKerStrs(object))

  cat("\n\n")

}
