% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootFbar.R
\name{bootstrap_fbar_sample}
\alias{bootstrap_fbar_sample}
\title{Internal Bootstrap Resampling for F-bar Test}
\usage{
bootstrap_fbar_sample(
  data,
  formula,
  grp,
  constraints,
  grp_val,
  grp_sizes,
  pre_calc,
  only_equality_constraints
)
}
\arguments{
\item{data}{A data frame containing the dataset for analysis.}

\item{formula}{An object of class \code{"formula"}: a symbolic description of
the model to be fitted.}

\item{grp}{A string specifying the grouping variable in the data.}

\item{constraints}{A matrix or data frame of constraints for the hypothesis test.}

\item{grp_val}{A vector containing the values of the group variable.}

\item{grp_sizes}{A table object containing the sizes of each group.}

\item{pre_calc}{A list containing pre-calculated original test statistics.}

\item{only_equality_constraints}{A logical indicating whether only equality
constraints are used.}
}
\value{
A list containing the test statistics for each constraint type
(B, A, F) based on the bootstrap sample. Returns NA values if the iht
computation fails.
}
\description{
This internal function performs bootstrap resampling specific to the F-bar test
within the context of the nonparametric bootstrap test with pooled resampling.
It is used by \code{bootFbar} to generate bootstrap samples and compute intermediate
statistics.
}
\details{
The function creates bootstrap samples for each group in the data, then binds
these samples together. It applies the \code{restriktor::iht} function on these
samples to compute the test statistics. Error handling is implemented to manage
potential issues in \code{iht} computation.
}
\keyword{internal}
