% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_mutate.R
\name{nest_mutate}
\alias{nest_mutate}
\alias{nest_transmute}
\title{Create, modify, and delete columns in nested data frames}
\usage{
nest_mutate(.data, .nest_data, ...)

nest_transmute(.data, .nest_data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item For \code{nest_mutate()}:
\itemize{
\item Columns from each object in \code{.nest_data} will be preserved according to
the \code{.keep} argument.
\item Existing columns that are modified by \code{...} will always be returned in
their original location.
\item New columns created through \code{...} will be placed according to the
\code{.before} and \code{.after} arguments.
}
\item For \code{nest_transmute()}:
\itemize{
\item Columns created or modified through \code{...} will be returned in the order
specified by \code{...}.
\item Unmodified grouping columns will be placed at the front.
}
\item The number of rows is not affected.
\item Columns given the value \code{NULL} will be removed.
\item Groups will be recomputed if a grouping variable is mutated.
\item Data frame attributes will be preserved.
}
}
\description{
\code{nest_mutate()} adds new variables to and preserves existing ones within
the nested data frames in \code{.nest_data}.
\code{nest_transmute()} adds new variables to and drops existing ones from the
nested data frames in \code{.nest_data}.
}
\details{
\code{nest_mutate()} and \code{nest_transmute()} are largely wrappers for
\code{\link[dplyr:mutate]{dplyr::mutate()}} and \code{\link[dplyr:mutate]{dplyr::transmute()}} and maintain the functionality of
\code{mutate()} and \code{transmute()} within each nested data frame. For more
information on \code{mutate()} or \code{transmute()}, please refer to the documentation
in \href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

# add or modify columns:
gm_nest \%>\%
  nest_mutate(
    country_data,
    lifeExp = NULL,
    gdp = gdpPercap * pop,
    pop = pop/1000000
  )
  
# use dplyr::across() to apply transformation to multiple columns 
gm_nest \%>\%
  nest_mutate(
    country_data,
    across(c(lifeExp:gdpPercap), mean)
  )

# nest_transmute() drops unused columns when mutating:
gm_nest \%>\%
  nest_transmute(
    country_data,
    country = country,
    year = year,
    pop = pop/1000000
  )
}
\seealso{
Other single table verbs: 
\code{\link{nest_arrange}()},
\code{\link{nest_filter}()},
\code{\link{nest_rename}()},
\code{\link{nest_select}()},
\code{\link{nest_slice}()},
\code{\link{nest_summarise}()}
}
\concept{single table verbs}
